//***************************************************************************
//
//  PROGRAM   : BNDEMO2.CPP
//
//  PROGRAMMER: Steven R Clabaugh
//              SRC Enterprises
//
//  PURPOSE   : SRC Enterprises Button Custom Control C++ programming examples
//              and demonstration program.
//
//***************************************************************************
#include <windows.h>
#include <srcentbn.h>
#include "bndemo2.h"

//***************************************************************************
//***************************************************************************
//
//      Global Variables
//
//***************************************************************************
//***************************************************************************
HINSTANCE hInst;   // current instance

char   MainWndClassName[] = "BNDemo2WClass",
       MainWndMenu[]      = "BNDemo2Menu",
       ProgTitle[]        = "BNDemo2 - Button Sample Application";

LPSTR cBuff  = "         ";

DWORD TextColor = RGB(0,0,0);

//***************************************************************************
//
//  FUNCTION: WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
//
//  PURPOSE: calls initialization function, processes message loop
//
//***************************************************************************
int PASCAL WinMain(HINSTANCE hInstance,        // current instance
                   HINSTANCE hPrevInstance,    // previous instance
                   LPSTR     lpCmdLine,        // command line
                   int       nCmdShow)         // show-window type

{

   MSG msg;  // message

   //****************************************************************

   if (!hPrevInstance)                  // Other instances of app running?
       if (!InitApplication(hInstance)) // Initialize shared things
           return (FALSE);              // Exits if unable to initialize

   // Perform initializations that apply to a specific instance
   if (!InitInstance(hInstance, nCmdShow))
       return (FALSE);

   // Acquire and dispatch messages until a WM_QUIT message is received.
   while (GetMessage(&msg,        // message structure
           NULL,                  // handle of window receiving the message
           NULL,                  // lowest message to examine
           NULL))                 // highest message to examine
   {
       TranslateMessage(&msg);    // Translates virtual key codes
       DispatchMessage(&msg);     // Dispatches message to window
   }

   UnregisterClass((LPSTR)MainWndClassName,hInst);

   return (msg.wParam);           // Returns the value from PostQuitMessage/

} // end WinMain

//***************************************************************************
//
//  FUNCTION: InitApplication(HINSTANCE)
//
//  PURPOSE: Initializes window data and registers window class
//
//***************************************************************************
BOOL InitApplication(HINSTANCE hInstance)
{

   WNDCLASS  wc;

   //****************************************************************

   // Fill in window class structure with parameters that describe the
   // main window.

   wc.style = NULL;
   wc.lpfnWndProc = (WNDPROC)MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(hInstance,"progicon");
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = GetStockObject(LTGRAY_BRUSH);
   wc.lpszMenuName =  MainWndMenu;
   wc.lpszClassName = MainWndClassName;

   // Register the window class and return success/failure code.
   return (RegisterClass(&wc));

}  // end InitApplication

//***************************************************************************
//
//  FUNCTION:  InitInstance(HINSTANCE, int)
//
//  PURPOSE:  Saves instance handle and creates main window
//
//***************************************************************************
BOOL InitInstance(HINSTANCE hInstance, // Current instance identifier.
                  int       nCmdShow)  // Param for first ShowWindow() call.
{

   HWND hWnd;              // Main window handle.

   //****************************************************************

   // Save the instance handle
   hInst = hInstance;

   // Create a main window for this application instance.
   hWnd = CreateWindow(
       MainWndClassName,
       ProgTitle,
       WS_OVERLAPPEDWINDOW,
       10,
       10,
       415,
       270,
       NULL,
       NULL,
       hInstance,
       NULL
   );

   // If window could not be created, return "failure"
   if (!hWnd)
       return (FALSE);

   // Make the window visible; update its client area; and return "success"
   ShowWindow(hWnd, nCmdShow);  // Show the window
   UpdateWindow(hWnd);          // Sends WM_PAINT message
   return (TRUE);               // Returns the value from PostQuitMessage

}  // end InitInstance

//***************************************************************************
//
//  FUNCTION: MainWndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages
//
//***************************************************************************
long FAR PASCAL __export MainWndProc(
                     HWND     hWnd,    // window handle
                     unsigned message, // type of message
                     WORD     wParam,  // additional information
                     LONG     lParam)  // additional information
{

   static HWND hVSPEdit1, // Window handles for the vertical
               hVSPEdit2, // Spin Buttons Edit controls              
               hVSPEdit3,
               hVSPEdit4,
               hVSPEdit5,
               hVSPEdit6,

               hHSPEdit1, // Window handles for the horizontal
               hHSPEdit2, // Spin Buttons Edit controls
               hHSPEdit3,
               hHSPEdit4,
               hHSPEdit5,
               hHSPEdit6,

               // Fancy Spin Button Edit Control
               hVEdit;

   // Declare Class Instances of all Buttons
   static CSRCEntBN

      // Vertical Spin Buttons
      VSpin1, VSpin2, VSpin3, VSpin4,VSpin5,VSpin6,

      // Horizontal Spin Buttons
      HSpin1, HSpin2, HSpin3, HSpin4,HSpin5,HSpin6,
      
      // 2-State Toggle Switch use to disable
      // and enable the vertical spin buttons.
      NFTSw,

      // Spin Button used to similate a 2-State 
      // Momentary Toggle Switch used to disable and enable the
      // horizontal Spin buttons.
      Switch1,
               
      // Color Buttons
      RedBut, GrnBut, BluBut, YelBut,
      CynBut, MagBut, GryBut, BlkBut,
                   
      // Fancy Spin Button
      Volume,

      // 2-State Push Style Button.
      // Used to Enable and disable the fancy volume button
      Voled;

   //****************************************************************

   switch (message)
   {

      case WM_CREATE:

         // Create Spin Button on the Main windlow client area.
         // This will be vertical, using the size 1 predefined bitmaps.
         VSpin1.Create(
            BTN_VERT | BTN_SPIN1,   // Vertical size 1 
            0,0,0,0,                // No User Bitmap
            20,10,                  // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            150,10,                 // Delay, Speed
            TRUE,                   // Use Hand Cursor
            hWnd,                   // Parent window handle
            VSPIN1,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hVSPEdit1 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            35,10,32,22,
            hWnd,
            VSPEDIT1,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",VSpin1.GetVal());
         SetWindowText(hVSPEdit1,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be vertical, using the size 2 predefined bitmaps.
         VSpin2.Create(
            BTN_VERT | BTN_SPIN2,   // Vertical size 2
            0,0,0,0,                // No User Bitmap
            18,40,                  // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            150,10,                 // Delay, Speed
            TRUE,                   // Use Hand Cursor
            hWnd,                   // Parent window handle
            VSPIN2,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hVSPEdit2 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            35,40,32,22,
            hWnd,
            VSPEDIT2,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",VSpin2.GetVal());
         SetWindowText(hVSPEdit2,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be vertical, using the size 3 predefined bitmaps.
         VSpin3.Create(
            BTN_VERT | BTN_SPIN3,   // Vertical size 3
            0,0,0,0,                // No User Bitmap
            16,70,                  // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            150,10,                 // Delay, Speed
            TRUE,                   // Use Hand Cursor
            hWnd,                   // Parent window handle
            VSPIN3,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hVSPEdit3 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            35,70,32,22,
            hWnd,
            VSPEDIT3,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",VSpin3.GetVal());
         SetWindowText(hVSPEdit3,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be vertical, using the size 4 predefined bitmaps.
         VSpin4.Create(
            BTN_VERT | BTN_SPIN4,   // Vertical size 4
            0,0,0,0,                // No User Bitmap
            14,100,                 // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            150,10,                 // Delay, Speed
            TRUE,                   // Use Hand Cursor
            hWnd,                   // Parent window handle
            VSPIN4,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hVSPEdit4 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            35,100,32,22,
            hWnd,
            VSPEDIT4,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",VSpin4.GetVal());
         SetWindowText(hVSPEdit4,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be vertical, using the size 5 predefined bitmaps.
         VSpin5.Create(
            BTN_VERT | BTN_SPIN5,   // Vertical size 5
            0,0,0,0,                // No User Bitmap
            12,130,                 // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            150,10,                 // Delay, Speed
            TRUE,                   // Use Hand Cursor
            hWnd,                   // Parent window handle
            VSPIN5,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hVSPEdit5 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            35,130,32,22,
            hWnd,
            VSPEDIT5,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",VSpin5.GetVal());
         SetWindowText(hVSPEdit5,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be vertical, using the size 6 predefined bitmaps.
         VSpin6.Create(
            BTN_VERT | BTN_SPIN6,   // Vertical size 6
            0,0,0,0,                // No User Bitmap
            10,160,                 // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            150,10,                 // Delay, Speed
            TRUE,                   // Use Hand Cursor
            hWnd,                   // Parent window handle
            VSPIN6,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hVSPEdit6 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            35,160,32,22,
            hWnd,
            VSPEDIT6,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",VSpin6.GetVal());
         SetWindowText(hVSPEdit6,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be horizontal, using the size 1 predefined bitmaps.
         HSpin1.Create(
            BTN_SPIN1 | BTN_WRAP,   // Horizontal size 1 w/Value Wrap
            0,0,0,0,                // No User Bitmap
            95,10,                  // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            500,150,                // Delay, Speed
            FALSE,                  // Use Arrow Cursor
            hWnd,                   // Parent window handle
            HSPIN1,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hHSPEdit1 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            115,10,32,22,
            hWnd,
            HSPEDIT1,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",HSpin1.GetVal());
         SetWindowText(hHSPEdit1,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be horizontal, using the size 2 predefined bitmaps.
         HSpin2.Create(
            BTN_SPIN2 | BTN_WRAP,   // Horizontal size 2 w/Value Wrap
            0,0,0,0,                // No User Bitmap
            93,40,                  // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            500,150,                // Delay, Speed
            FALSE,                  // Use Arrow Cursor
            hWnd,                   // Parent window handle
            HSPIN2,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hHSPEdit2 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            115,40,32,22,
            hWnd,
            HSPEDIT2,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",HSpin2.GetVal());
         SetWindowText(hHSPEdit2,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be horizontal, using the size 3 predefined bitmaps.
         HSpin3.Create(
            BTN_SPIN3 | BTN_WRAP,   // Horizontal size 3 w/Value Wrap
            0,0,0,0,                // No User Bitmap
            91,70,                  // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            500,150,                // Delay, Speed
            FALSE,                  // Use Arrow Cursor
            hWnd,                   // Parent window handle
            HSPIN3,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hHSPEdit3 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            115,70,32,22,
            hWnd,
            HSPEDIT3,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",HSpin3.GetVal());
         SetWindowText(hHSPEdit3,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be horizontal, using the size 4 predefined bitmaps.
         HSpin4.Create(
            BTN_SPIN4 | BTN_WRAP,   // Horizontal size 4 w/Value Wrap
            0,0,0,0,                // No User Bitmap
            89,100,                 // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            500,150,                // Delay, Speed
            FALSE,                  // Use Arrow Cursor
            hWnd,                   // Parent window handle
            HSPIN4,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hHSPEdit4 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            115,100,32,22,
            hWnd,
            HSPEDIT4,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",HSpin4.GetVal());
         SetWindowText(hHSPEdit4,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be horizontal, using the size 5 predefined bitmaps.
         HSpin5.Create(
            BTN_SPIN5 | BTN_WRAP,   // Horizontal size 5 w/Value Wrap
            0,0,0,0,                // No User Bitmap
            87,130,                 // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            500,150,                // Delay, Speed
            FALSE,                  // Use Arrow Cursor
            hWnd,                   // Parent window handle
            HSPIN5,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hHSPEdit5 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            115,130,32,22,
            hWnd,
            HSPEDIT5,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",HSpin5.GetVal());
         SetWindowText(hHSPEdit5,cBuff);

         // Create Spin Button on the Main windlow client area.
         // This will be horizontal, using the size 6 predefined bitmaps.
         HSpin6.Create(
            BTN_SPIN6 | BTN_WRAP,   // Horizontal size 6 w/Value Wrap
            0,0,0,0,                // No User Bitmap
            85,160,                 // Spin button position
            0,0,                    // Spin button size (use defaults)
            1,                      // Step value
            0,100,                  // range
            50,                     // Initial value
            500,150,                // Delay, Speed
            FALSE,                  // Use Arrow Cursor
            hWnd,                   // Parent window handle
            HSPIN6,                 // ID Value
            hInst);                 // This instance owns this window

         // EDIT control to display the above Spin Button value
         hHSPEdit6 = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            115,160,32,22,
            hWnd,
            HSPEDIT6,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",HSpin6.GetVal());
         SetWindowText(hHSPEdit6,cBuff);

         // This is a 2-State Toggle Switch located directly beneath the
         // 6 vertical spin button.  It is used as a switch to enable and
         // disable the vertical spin buttons.
         NFTSw.Create(
            BTN_T2S,         // 2-State Toggle Button Type
            "nftlo",         // Bitmap name for state 1 position
            "nfthi",         // Bitmap name for state 2 position
            "nftlog",        // Bitmap name for disabled state 1 position
            "nfthig",        // Bitmap name for disabled state 2 position
            15,200,          // Button position
            0,0,             // Button size (use bitmap size)
            1,               // Step value
            0,1,             // Range
            1,               // Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            NFTSW,           // ID Value
            hInst);          // This instance owns this window

         // This User defined Spin Button is used to simulate a 2-State
         // Momentary Toggle Switch located directly beneath the 6 horizontal
         // Spin buttons.  It is used as a switch to enable and
         // disable the horizontal spin buttons.
         Switch1.Create(
            BTN_SPINU,       // User defined Spin Button Type
            "switch1",       // Bitmap name for Unpushed State
            "switch1n",      // Bitmap name for Incrementing State
            "switch1f",      // Bitmap name for Decrementing State
            0,               // No Bitmap for Disabled State
            90,200,          // Button position
            0,0,             // Button size (use bitmap size)
            1,               // Step value
            0,1,             // Range
            1,               // Initial value
            1,1,             // Delay, Speed
            FALSE,           // Use Arrow Cursor
            hWnd,            // Parent window handle
            SWITCH1,         // ID Value
            hInst);          // This instance owns this window

         // Create a Red Color Button on the Main windlow client area.
         RedBut.Create(
            BTN_RED,         // Red Color Button Type
            0,0,0,0,         // No Bitmaps
            180,10,          // Button position
            15,15,           // Button size
            0,               // No Step Value
            0,0,             // No Range
            0,               // No Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            REDBUTTON,       // ID Value
            hInst);          // This instance owns this window

         // Create a Green Color Button on the Main windlow client area.
         GrnBut.Create(
            BTN_GRN,         // Green Color Button Type
            0,0,0,0,         // No Bitmaps
            205,10,          // Button position
            15,15,           // Button size
            0,               // No Step Value
            0,0,             // No Range
            0,               // No Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            GRNBUTTON,       // ID Value
            hInst);          // This instance owns this window

         // Create a Blue Color Button on the Main windlow client area.
         BluBut.Create(
            BTN_BLU,         // Blue Color Button Type
            0,0,0,0,         // No Bitmaps
            230,10,          // Button position
            15,15,           // Button size
            0,               // No Step Value
            0,0,             // No Range
            0,               // No Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            BLUBUTTON,       // ID Value
            hInst);          // This instance owns this window

         // Create a Yellow Color Button on the Main windlow client area.
         YelBut.Create(
            BTN_YEL,         // Yellow Color Button Type
            0,0,0,0,         // No Bitmaps
            255,10,          // Button position
            15,15,           // Button size
            0,               // No Step Value
            0,0,             // No Range
            0,               // No Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            YELBUTTON,       // ID Value
            hInst);          // This instance owns this window

         // Create a Cyan Color Button on the Main windlow client area.
         CynBut.Create(
            BTN_CYN,         // Cyan Color Button Type
            0,0,0,0,         // No Bitmaps
            280,10,          // Button position
            15,15,           // Button size
            0,               // No Step Value
            0,0,             // No Range
            0,               // No Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            CYNBUTTON,       // ID Value
            hInst);          // This instance owns this window

         // Create a Magenta Color Button on the Main windlow client area.
         MagBut.Create(
            BTN_MAG,         // Magenta Color Button Type
            0,0,0,0,         // No Bitmaps
            305,10,          // Button position
            15,15,           // Button size
            0,               // No Step Value
            0,0,             // No Range
            0,               // No Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            MAGBUTTON,       // ID Value
            hInst);          // This instance owns this window

         // Create a Gray Color Button on the Main windlow client area.
         GryBut.Create(
            BTN_GRY,         // Gray Color Button Type
            0,0,0,0,         // No Bitmaps
            330,10,          // Button position
            15,15,           // Button size
            0,               // No Step Value
            0,0,             // No Range
            0,               // No Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            GRYBUTTON,       // ID Value
            hInst);          // This instance owns this window

         // Create a Black Color Button on the Main windlow client area.
         BlkBut.Create(
            BTN_BLK,         // Black Color Button Type
            0,0,0,0,         // No Bitmaps
            355,10,          // Button position
            15,15,           // Button size
            0,               // No Step Value
            0,0,             // No Range
            0,               // No Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            BLKBUTTON,       // ID Value
            hInst);          // This instance owns this window

         // Create Spin Button for the fancy looking Volume Control
         Volume.Create(
            BTN_SPINU,       // User defined Spin Button Type
            "volume",        // Bitmap name for Unpushed State
            "volumei",       // Bitmap name for Incrementing State
            "volumed",       // Bitmap name for Decrementing State
            "volumeg",       // Bitmap name for Disabled State
            200,100,         // Button position
            0,0,             // Button size (use bitmap size)
            1,               // Step value
            0,100,           // Range
            0,               // Initial value
            200,100,         // Delay, Speed
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            VOLUME,          // ID Value
            hInst);          // This instance owns this window

         // EDIT control to display the above Spin Button value
         hVEdit = CreateWindow(
            "EDIT",
            "0",
            WS_CHILD | WS_VISIBLE | WS_BORDER | WS_DISABLED,
            200,77,47,22,
            hWnd,
            VEDIT,
            hInst,
            NULL
         );
         wsprintf(cBuff,"%d",Volume.GetVal());
         SetWindowText(hVEdit,cBuff);

         // Create 2-State Push Button That will enable and disable
         // the fancy looking Volume Control
         Voled.Create(
            BTN_P2S,         // 2-State Push Button Type
            "vold",          // Bitmap name for Unpushed State 1
            "vole",          // Bitmap name for Unpushed State 2
            "volp",          // Bitmap name for Pushed State
            "0",             // No Bitmap for Disabled State
            200,121,         // Button position
            0,0,             // Button size (use bitmap size)
            1,               // Step value
            0,1,             // Range
            1,               // Initial value
            1,1,             // Delay, Speed  (Ingore by this type anyway)
            TRUE,            // Use Hand Cursor
            hWnd,            // Parent window handle
            VOLED,           // ID Value
            hInst);          // This instance owns this window

      break;  // end WM_CREATE
   
      case WM_COMMAND:

         switch (wParam)
         {

            case VSPIN1:
               wsprintf(cBuff,"%d",VSpin1.GetVal());
               SetWindowText(hVSPEdit1,cBuff);
               UpdateWindow(hVSPEdit1);
            break;

            case VSPIN2:
               wsprintf(cBuff,"%d",VSpin2.GetVal());
               SetWindowText(hVSPEdit2,cBuff);
               UpdateWindow(hVSPEdit2);
            break;

            case VSPIN3:
               wsprintf(cBuff,"%d",VSpin3.GetVal());
               SetWindowText(hVSPEdit3,cBuff);
               UpdateWindow(hVSPEdit3);
            break;

            case VSPIN4:
               wsprintf(cBuff,"%d",VSpin4.GetVal());
               SetWindowText(hVSPEdit4,cBuff);
               UpdateWindow(hVSPEdit4);
            break;

            case VSPIN5:
               wsprintf(cBuff,"%d",VSpin5.GetVal());
               SetWindowText(hVSPEdit5,cBuff);
               UpdateWindow(hVSPEdit5);
            break;

            case VSPIN6:
               wsprintf(cBuff,"%d",VSpin6.GetVal());
               SetWindowText(hVSPEdit6,cBuff);
               UpdateWindow(hVSPEdit6);
            break;

            case HSPIN1:
               wsprintf(cBuff,"%d",HSpin1.GetVal());
               SetWindowText(hHSPEdit1,cBuff);
               UpdateWindow(hHSPEdit1);
            break;

            case HSPIN2:
               wsprintf(cBuff,"%d",HSpin2.GetVal());
               SetWindowText(hHSPEdit2,cBuff);
               UpdateWindow(hHSPEdit2);
            break;

            case HSPIN3:
               wsprintf(cBuff,"%d",HSpin3.GetVal());
               SetWindowText(hHSPEdit3,cBuff);
               UpdateWindow(hHSPEdit3);
            break;

            case HSPIN4:
               wsprintf(cBuff,"%d",HSpin4.GetVal());
               SetWindowText(hHSPEdit4,cBuff);
               UpdateWindow(hHSPEdit4);
            break;

            case HSPIN5:
               wsprintf(cBuff,"%d",HSpin5.GetVal());
               SetWindowText(hHSPEdit5,cBuff);
               UpdateWindow(hHSPEdit5);
            break;

            case HSPIN6:
               wsprintf(cBuff,"%d",HSpin6.GetVal());
               SetWindowText(hHSPEdit6,cBuff);
               UpdateWindow(hHSPEdit6);
            break;

            // 2-State Toggle Switch that disables and disables the 
            // vertical spin buttons.
            case NFTSW:
               if (NFTSw.GetVal())  // Enable Vertical Spin Buttons
               {
                  VSpin1.Enable(TRUE);
                  VSpin2.Enable(TRUE);
                  VSpin3.Enable(TRUE);
                  VSpin4.Enable(TRUE);
                  VSpin5.Enable(TRUE);
                  VSpin6.Enable(TRUE);
               }
               else   // Disable Vertical Spin Buttons
               {
                  VSpin1.Enable(FALSE);
                  VSpin2.Enable(FALSE);
                  VSpin3.Enable(FALSE);
                  VSpin4.Enable(FALSE);
                  VSpin5.Enable(FALSE);
                  VSpin6.Enable(FALSE);
               }
            break;

            // Spin Button that similates a 2-State Momentary Toggle Switch that
            // disables and disables the horizontal spin buttons.
            case SWITCH1:
               if (Switch1.GetVal())  // Enable Horizontal Spin Buttons
               {
                  HSpin1.Enable(TRUE);
                  HSpin2.Enable(TRUE);
                  HSpin3.Enable(TRUE);
                  HSpin4.Enable(TRUE);
                  HSpin5.Enable(TRUE);
                  HSpin6.Enable(TRUE);
               }
               else   // Disable Horizontal Spin Buttons
               {
                  HSpin1.Enable(FALSE);
                  HSpin2.Enable(FALSE);
                  HSpin3.Enable(FALSE);
                  HSpin4.Enable(FALSE);
                  HSpin5.Enable(FALSE);
                  HSpin6.Enable(FALSE);
               }
            break;

            case REDBUTTON:
               TextColor = RGB(255,0,0);
               InvalidateRect(hWnd,NULL,FALSE);
            break;

            case GRNBUTTON:
               TextColor = RGB(0,255,0);
               InvalidateRect(hWnd,NULL,FALSE);
            break;

            case BLUBUTTON:
               TextColor = RGB(0,0,255);
               InvalidateRect(hWnd,NULL,FALSE);
            break;

            case YELBUTTON:
               TextColor = RGB(255,255,0);
               InvalidateRect(hWnd,NULL,FALSE);
            break;

            case CYNBUTTON:
               TextColor = RGB(0,255,255);
               InvalidateRect(hWnd,NULL,FALSE);
            break;

            case MAGBUTTON:
               TextColor = RGB(255,0,255);
               InvalidateRect(hWnd,NULL,FALSE);
            break;

            case GRYBUTTON:
               TextColor = RGB(128,128,128);
               InvalidateRect(hWnd,NULL,FALSE);
            break;

            case BLKBUTTON:
               TextColor = RGB(0,0,0);
               InvalidateRect(hWnd,NULL,FALSE);
            break;

            case VOLUME:
               wsprintf(cBuff,"%d",Volume.GetVal());
               SetWindowText(hVEdit,cBuff);
               UpdateWindow(hVEdit);
            break;

            case VOLED:
               if (Voled.GetVal())
                  Volume.Enable(TRUE);
                else
                  Volume.Enable(FALSE);
            break;

            case IDM_ABOUT:
            {

               FARPROC lpProcAbout; // pointer to the "About" function

               //*******************************************************

               lpProcAbout = MakeProcInstance((FARPROC)About, hInst);
               DialogBox(hInst,
                         "AboutBox",
                         hWnd,
                         lpProcAbout);

               FreeProcInstance(lpProcAbout);
            }
            break;

         } // end switch(wParam)

      break; // end WM_COMMAND

      case WM_PAINT:
      {

         PAINTSTRUCT ps;

         //**********************************************************

         BeginPaint(hWnd,&ps);
         SetBkColor(ps.hdc,RGB(192,192,192));
         SetTextColor(ps.hdc,TextColor);
         TextOut(ps.hdc,160,30,"Change Text Color With Color Button",35);
         EndPaint(hWnd,&ps);
      }
      break;  // end WM_PAINT

      case WM_DESTROY:                  // window being destroyed
         PostQuitMessage(0);
      break;

      default:   // Passes it on if unproccessed
         return (DefWindowProc(hWnd, message, wParam, lParam));

   }

   return (NULL);

} // end MainWndProc

//***************************************************************************
//
//  FUNCTION: About(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  "About" dialog box
//
//***************************************************************************
BOOL FAR PASCAL __export About(HWND     hDlg,
                               unsigned message,
                               WORD     wParam,
                               LONG     lParam)

{

   BOOL bRC;

   //****************************************************************

   bRC = TRUE;

   switch (message)
   {

      case WM_INITDIALOG:
      break;

      case WM_COMMAND:
         switch (wParam)
         {

            case IDOK:
            case IDCANCEL:
               EndDialog(hDlg,TRUE);
            break;

         } // end switch(wParam)

      break;

      default:
         bRC = FALSE;  // Didn't process a message

   } // end switch(message)

   return (bRC);

}  // end About
